﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Visifire.Charts;
using Visifire.Commons;

namespace _11.LINQtoSQL
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            ServiceReference1.Service1Client client = new _11.LINQtoSQL.ServiceReference1.Service1Client();
            client.GetChartDataCompleted += new EventHandler<_11.LINQtoSQL.ServiceReference1.GetChartDataCompletedEventArgs>(client_GetChartDataCompleted);
            client.GetChartDataAsync();
        }
        void client_GetChartDataCompleted(object sender, _11.LINQtoSQL.ServiceReference1.GetChartDataCompletedEventArgs e)
        {
            Chart chart = new Chart();
            chart.Width = 400;
            chart.Height = 300;

            DataSeries ds = new DataSeries();

            foreach (var data in e.Result)
            {
                DataPoint dp = new DataPoint();
                dp.AxisXLabel = data.ProductName;
                dp.YValue = Convert.ToDouble(data.UnitPrice);
                ds.DataPoints.Add(dp);
            }

            chart.Series.Add(ds);

            LayoutRoot.Children.Add(chart);
        }
    }
}
